package gov.va.med.mhv.usermgmt.form;

import gov.va.med.mhv.usermgmt.messages.EmployeeManagementMessages;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.MessageUtils;
import gov.va.med.mhv.core.web.util.XSSProcessor;

/**
 * The EmployeeSearchForm class is responsible for handling user input.
 */
public class EmployeeSearchForm extends EmployeeSearchBaseForm {
	private static final long serialVersionUID = 3710598724148359064L;

	protected void doReset(ActionMapping mapping, HttpServletRequest request) {	}

	protected void additionalValidation(HttpServletRequest request){
		cleanXSS();
		if (!isValidLastNameSearch() && !isValidUserNameSearch())
		   getMessages().addMessage(MessageUtils.createErrorMessage(
				   EmployeeManagementMessages.SEARCH_INVALID_CRITERIA,null,null));
	}

	public boolean isValidLastNameSearch(){
		if(getLastName() == null)
			return false;

		String validLastName = getLastName().replaceAll("\\*","");  //no user entered wildcards allowed

		//can't be blank, must be more than 1 character
		if(StringUtils.isNotBlank(validLastName) && validLastName.trim().length() > 2)
			return true;
		else
			return false;
	}

	public boolean isValidUserNameSearch(){
		if(getUserName() == null)
			return false;

		String validUserName = getUserName().replaceAll("\\*","");  //no user entered wildcards allowed
		if(StringUtils.isNotBlank(validUserName))
			return true;
		else
			return false;
	}

	private void cleanXSS() {
		setLastName( XSSProcessor.cleanXSS(  getLastName() ) );
		setUserName( XSSProcessor.cleanXSS( getUserName() ) );
		setFirstName( XSSProcessor.cleanXSS( getFirstName() ) );
	}


}